

--SelectMusic Positions

--This calls on the ThemePrefRow's current setting.
function WideSSM()
  return ThemePrefs.Get("XStyledMusicSelect") == "Wide Style"
end 


--This is where the magic happens, Simply add a line with what you want the the function to be named.
--The first value will be the X coords if the ThemePref row is set to "Wide Style" while the second is "X Style"
SelectMusicXPositions = 
{
  Style = {SCREEN_LEFT+33, SCREEN_CENTER_X-282},
  Banner = {SCREEN_LEFT+141, SCREEN_CENTER_X - 179},
  BannerFrame = {SCREEN_LEFT+152, SCREEN_CENTER_X - 168},
  CD = {SCREEN_LEFT+250, SCREEN_CENTER_X-70},
  Stage = {SCREEN_LEFT+160, SCREEN_CENTER_X-160},
  BPMNum = {SCREEN_LEFT+250, SCREEN_CENTER_X-70},
  Radar = {SCREEN_LEFT + 149, SCREEN_CENTER_X-171},
  Balloon = {SCREEN_RIGHT-240, SCREEN_CENTER_X+80},
  Wheel = {SCREEN_RIGHT-166, SCREEN_CENTER_X+154},
}

--This adds "PosX" to the end of whatever you named your line in the table above.
-- For example, it takes "Banner" and adds "PosX" to the end, making it "BannerPosX".
for name, entry in pairs(SelectMusicXPositions) do
  _G[name.."PosX"] = function()
    return WideSSM() and entry[1] or entry[2]
  end
end

--This is where we set the ScrollBar's X coord, so to speak.
function WheelScrollOn(self)
  local DO = 99
  if ThemePrefs.Get("XStyledMusicSelect") == "Wide Style" then
    self:draworder(DO)
    self:x(156)
  else
    self:draworder(DO)
    self:x(263)
  end
end
